﻿namespace Hims.Api.Controllers
{
    using Domain.Services;
    using Hims.Shared.UserModels.NurseShift;
    using Hims.Shared.UserModels.Common;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using System;
    using System.Threading.Tasks;
    using Utilities;
    using Hims.Domain.Helpers;
    using System.Collections.Generic;

    /// <inheritdoc />
    [Authorize]
    [Route("api/nurse-shift")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class NurseShiftController : BaseController
    {
        /// <summary>
        /// The coupon services.
        /// </summary>
        private readonly INurseShiftService service;

        /// <summary>
        /// The aes helper
        /// </summary>
        private readonly IAESHelper aesHelper;

        /// <inheritdoc />
        public NurseShiftController(INurseShiftService service, IAESHelper aesHelper)
        {
            this.service = service;
            this.aesHelper = aesHelper;
        }

        /// <summary>
        /// The fetch nurse.
        /// </summary>
        /// <returns>
        /// The list of nurse.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of Widgets.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("fetch-beds")]
        public async Task<ActionResult> FetchBedsAsync([FromBody] BedFilterModel model)
        {
            try
            {
                var records = await this.service.FetchBedsAsync(model);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success,
                    Data = records
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }

        /// <summary>
        /// The fetch nurse.
        /// </summary>
        /// <returns>
        /// The list of nurse.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of Widgets.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("fetch-beds-basic")]
        public async Task<ActionResult> FetchBedsBasicAsync([FromBody] GetPayload model)
        {
            try
            {
                var records = await this.service.FetchBedsBasicAsync(model);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success,
                    Data = records
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }

        [HttpPost]
        [Route("copy")]
        public async Task<ActionResult> CopyShiftsAsync([FromBody] CopyPayload model)
        {
            try
            {
                var records = await this.service.CopyShiftsAsync(model);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }

        /// <summary>
        /// The fetch nurse.
        /// </summary>
        /// <returns>
        /// The list of nurse.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of Widgets.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("fetch")]
        public async Task<ActionResult> FetchAsync([FromBody] GetPayload model)
        {
            try
            {
                model.Value = Convert.ToInt32(this.aesHelper.Decrypt(model.Id));
                var records = await this.service.FetchAsync(model);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success,
                    Data = records
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }

        /// <summary>
        /// The fetch nurse.
        /// </summary>
        /// <returns>
        /// The list of nurse.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of Widgets.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("get-nurse")]
        public async Task<ActionResult> GetNurseAsync([FromBody] GetPayload model)
        {
            try
            {
                model.Value = Convert.ToInt32(this.aesHelper.Decrypt(model.Id));
                var records = await this.service.GetNurseAsync(model);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success,
                    Data = records
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }

        /// <summary>
        /// The fetch nurse.
        /// </summary>
        /// <returns>
        /// The list of nurse.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of Widgets.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("insert")]
        public async Task<ActionResult> InsertAsync([FromBody] InsertModel model)
        {
            try
            {
                
                model.NurseId = Convert.ToInt32(this.aesHelper.Decrypt(model.Id));
                var records = await this.service.InsertAsync(model);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success,
                    Data = records
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }

        /// <summary>
        /// The fetch nurse.
        /// </summary>
        /// <returns>
        /// The list of nurse.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of Widgets.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("move")]
        public async Task<ActionResult> MoveAsync([FromBody] MoveModel model)
        {
            try
            {
                var time = TimeSpan.Parse(model.Time);
                model.Hour = time.Hours;
                model.Minute = time.Minutes;
                var records = await this.service.MoveAsync(model);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success,
                    Data = records
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }

        /// <summary>
        /// The fetch nurse.
        /// </summary>
        /// <returns>
        /// The list of nurse.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of Widgets.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("fetch-moves")]
        public async Task<ActionResult> FetchMovesAsync([FromBody] GetPayload model)
        {
            try
            {
                var records = await this.service.FetchMovesAsync(model);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success,
                    Data = records
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }

        /// <summary>
        /// The fetch nurse.
        /// </summary>
        /// <returns>
        /// The list of nurse.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of Widgets.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("update")]
        public async Task<ActionResult> UpdateAsync([FromBody] UpdateModel model)
        {
            try
            {
                
                model.NurseId = Convert.ToInt32(this.aesHelper.Decrypt(model.Id));
                var records = await this.service.UpdateAsync(model);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success,
                    Data = records
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }
    }
}